# J27 — TOF SI Overlay (seconds) — Reproducible Repo (PASS: 2025-11-06T23-03-08Z)

This archive contains a passing run of **J27: TOF SI Overlay (seconds)** and the exact engine needed to reproduce it.

**One-line result:**  
`J27 PASS=True c_hat_si=1.000000 c_pred_si=1.000000 r2_native=1.0000 r2_si=1.0000 overlay_rel_diff=0.00e+00`

## Contents
```
J27_TOF_SI_Overlay_PASS_2025-11-06T23-03-08Z/
├─ engine_j27_tof_overlay.py
├─ J27_tof_overlay/
│  └─ 2025-11-06T23-03-08Z/
│     ├─ config/manifest_j27.json
│     ├─ outputs/
│     │  ├─ metrics/j27_tof_arrivals.csv
│     │  ├─ audits/j27_audit.json
│     │  └─ run_info/result_line.txt
│     └─ logs/env.txt
├─ run_same_workspace.sh
├─ run_same_workspace.bat
└─ run_new_ts.py
```

## Quickstart

### A) Re-run the included PASS workspace (overwrites outputs in-place)
Linux/macOS:
```bash
bash run_same_workspace.sh
```

Windows (PowerShell or cmd):
```bat
run_same_workspace.bat
```

### B) Create a **new** UTC-timestamped workspace and run
```bash
python3 run_new_ts.py
```
This will create `J27_tof_overlay/<NEW_UTC>/`, copy the included manifest, run the engine, and print the one-line result.

## Expected PASS criteria
- Native and SI linear fits `r^2 ≥ 0.98`
- `|ĉ_SI − c_pred_SI| / c_pred_SI ≤ 0.02`
- Overlay invariance: `ĉ_SI = ĉ_native × (dx/dt)` within `1e-9`
- Native arrays’ hash unchanged (no mutation by overlay)

## Notes
- The engine uses only the Python **standard library**, no external deps.
- To use a hinge calibration, edit `hinge` fields in the manifest before running.
